# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .page_schema2 import PageSchema2
from .preview_schema2 import PreviewSchema2


class FileSchema(UniversalBaseModel):
    """
    Represents a file (such as a PDF invoice) that was uploaded to Monite.
    """

    id: str = pydantic.Field()
    """
    A unique ID of this file.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    UTC date and time when this file was uploaded to Monite. Timestamps follow the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format.
    """

    file_type: str = pydantic.Field()
    """
    The type of the business object associated with this file.
    """

    name: str = pydantic.Field()
    """
    The original file name (if available).
    """

    region: str = pydantic.Field()
    """
    Geographical region of the data center where the file is stored.
    """

    md5: str = pydantic.Field()
    """
    The MD5 hash of the file.
    """

    mimetype: str = pydantic.Field()
    """
    The file's [media type](https://developer.mozilla.org/en-US/docs/Web/HTTP/MIME_types).
    """

    url: str = pydantic.Field()
    """
    The URL to download the file.
    """

    size: int = pydantic.Field()
    """
    The file size in bytes.
    """

    previews: typing.Optional[typing.List[PreviewSchema2]] = pydantic.Field(default=None)
    """
    Preview images generated for this file. There can be multiple images with different sizes.
    """

    pages: typing.Optional[typing.List[PageSchema2]] = pydantic.Field(default=None)
    """
    If the file is a PDF document, this property contains individual pages extracted from the file. Otherwise, an empty array.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
