# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .currency_enum import CurrencyEnum
from .pricing_plan import PricingPlan
from .wc_offer_status import WcOfferStatus


class FinancingOffer(UniversalBaseModel):
    status: WcOfferStatus = pydantic.Field()
    """
    The status of the financing offer.
    """

    total_amount: int = pydantic.Field()
    """
    The total credit limit in minor units.
    """

    available_amount: typing.Optional[int] = pydantic.Field(default=None)
    """
    The available credit limit in minor units.
    """

    currency: CurrencyEnum = pydantic.Field()
    """
    The currency code.
    """

    pricing_plans: typing.List[PricingPlan] = pydantic.Field()
    """
    A list of pricing plans for the offer.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
