# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .currency_enum import CurrencyEnum


class LedgerAccountResponse(UniversalBaseModel):
    """
    Represents a general ledger account retrieved from an accounting system.
    """

    id: str = pydantic.Field()
    """
    A unique identifier of the ledger account.
    """

    currency: typing.Optional[CurrencyEnum] = pydantic.Field(default=None)
    """
    The currency of the ledger account, specified as a three-letter [currency code](https://docs.monite.com/references/currencies) (ISO 4217).
    """

    current_balance: typing.Optional[int] = pydantic.Field(default=None)
    """
    The current balance in the account.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    User-defined description of the ledger account.
    """

    is_bank_account: bool = pydantic.Field()
    """
    Indicates whether this ledger account represents a bank account.
    """

    name: str = pydantic.Field()
    """
    A user-defined name of the ledger account. Examples: Accounts Receivable, Office Equipment, Advertising, Salaries.
    """

    nominal_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account code in the accounting system.
    """

    status: str = pydantic.Field()
    """
    The status of the ledger account. Possible values: Active, Archived, Pending, Unknown.
    """

    subtype: typing.Optional[str] = pydantic.Field(default=None)
    """
    The subtype or category of the ledger account. Possible values vary based on the accounting system used. Examples: Current, Fixed, Expense, Inventory, Equity.
    """

    type: str = pydantic.Field()
    """
    The type of the ledger account. It determines whether the account is a credit account or a debit account and where it appears in financial reports within the accounting system. Possible values: Asset, Equity, Expense, Income, Liability, Unknown.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
