# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class LineItemInternalRequest(UniversalBaseModel):
    accounting_tax_rate_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the tax rate reference used for accounting integration. May be used to override auto-picked tax rate reference in accounting platform in case of any platform-specific constraints.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the product.
    """

    ledger_account_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the account record used to store bookkeeping entries for balance-sheet and income-statement transactions.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the product.
    """

    quantity: typing.Optional[float] = pydantic.Field(default=None)
    """
    The quantity of each of the goods, materials, or services listed in the payable.
    """

    subtotal: typing.Optional[int] = None
    tax: typing.Optional[int] = pydantic.Field(default=None)
    """
    VAT rate in percent [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.
    """

    total: typing.Optional[int] = None
    unit: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unit of the product
    """

    unit_price: typing.Optional[int] = pydantic.Field(default=None)
    """
    The unit price of the product, in [minor units](https://docs.monite.com/references/currencies#minor-units). For example, $12.50 is represented as 1250.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
