# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .line_item_product_measure_unit import LineItemProductMeasureUnit
from .line_item_product_vat_rate import LineItemProductVatRate
from .price import Price
from .product_service_type_enum import ProductServiceTypeEnum


class LineItemProduct(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Unique ID of the product.
    """

    accounting_tax_rate_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the accounting tax rate object.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the product.
    """

    is_inline: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the product is inline
    """

    ledger_account_id: typing.Optional[str] = None
    measure_unit: typing.Optional[LineItemProductMeasureUnit] = None
    name: str = pydantic.Field()
    """
    Name of the product.
    """

    price: Price
    price_after_vat: Price
    smallest_amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    The smallest amount allowed for this product.
    """

    type: typing.Optional[ProductServiceTypeEnum] = pydantic.Field(default=None)
    """
    Specifies whether this offering is a product or service. This may affect the applicable tax rates.
    """

    vat_rate: LineItemProductVatRate

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
