# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class LineItemResponse(UniversalBaseModel):
    id: str
    accounting_tax_rate_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the tax rate reference used for accounting integartion. May be used to override auto-picked tax rate reference in accounting platform in case of any platform-specific constraints.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the product.
    """

    ledger_account_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the account record used to store bookkeeping entries for balance-sheet and income-statement transactions.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the product.
    """

    ocr_set_quantity_to_one: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the item's `unit_price` and `quantity` were adjusted by OCR.
    """

    payable_id: str
    quantity: typing.Optional[float] = pydantic.Field(default=None)
    """
    The quantity of each of the goods, materials, or services listed in the payable.
    """

    subtotal: typing.Optional[int] = pydantic.Field(default=None)
    """
    The subtotal (excluding VAT), in [minor units](https://docs.monite.com/references/currencies#minor-units).
    """

    tax: typing.Optional[int] = pydantic.Field(default=None)
    """
    VAT rate in percent [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.
    """

    tax_amount: typing.Optional[int] = pydantic.Field(default=None)
    """
    Tax amount in [minor units](https://docs.monite.com/references/currencies#minor-units). For example, $12.50 is represented as 1250.
    """

    total: typing.Optional[int] = pydantic.Field(default=None)
    """
    The actual price of the product.
    """

    unit: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unit of the product
    """

    unit_price: typing.Optional[int] = pydantic.Field(default=None)
    """
    The unit price of the product, in [minor units](https://docs.monite.com/references/currencies#minor-units). For example, $12.50 is represented as 1250.
    """

    was_created_by_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user who created the tag.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
