# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class OcrAddress(UniversalBaseModel):
    """
    In general it's compatible with CounterpartAddress model but
    * All fields are optional
    * There is an additional field original_country_name
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    Two-letter ISO country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
    """

    original_country_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Country name as it is stated in the document.
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    City name.
    """

    postal_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    ZIP or postal code.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    State, region, province, or county.
    """

    line1: typing.Optional[str] = pydantic.Field(default=None)
    """
    Street address.
    """

    line2: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional address information (if any).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
