# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class OcrAutoTaggingSettingsRequest(UniversalBaseModel):
    enabled: bool = pydantic.Field()
    """
    A switch to temporarily disable a keyword without removing it from the list.
    """

    keywords: typing.List[str] = pydantic.Field()
    """
    A list of words that will be searched for assigning a tag in the recognized fields of the document after OCR processing. If at least one match is found, the tag will be assigned. Each keyword must be between 2 and 25 characters long.
    """

    tag_id: str = pydantic.Field()
    """
    Tag identifier that will be assigned to the payable document if one of the words listed in keywords is found during OCR.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
