# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .label_n_value import LabelNValue


class OcrRecognitionResponse(UniversalBaseModel):
    """
    Contains information about all text blocks extracted from an uploaded invoice by OCR.
    The text blocks are grouped into `line_items` (invoice line items) and `summary` (all other information).
    Legacy schema used for AWS textract recognition.
    """

    summary: typing.Optional[typing.List[LabelNValue]] = pydantic.Field(default=None)
    """
    Invoice text content other than the line items. Such as the invoice issue and due dates, vendor name and address, and other general information.
    """

    line_items: typing.Optional[typing.List[LabelNValue]] = pydantic.Field(default=None)
    """
    Text content of the invoice line items as recognized by OCR.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
