# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .entity_business_structure import EntityBusinessStructure


class OptionalOrganizationSchema(UniversalBaseModel):
    """
    A schema contains metadata for updating an organization
    """

    business_structure: typing.Optional[EntityBusinessStructure] = pydantic.Field(default=None)
    """
    Business structure of the company
    """

    directors_provided: typing.Optional[bool] = None
    executives_provided: typing.Optional[bool] = None
    legal_entity_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A code which identifies uniquely a party of a transaction worldwide
    """

    legal_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A legal name of an organization
    """

    owners_provided: typing.Optional[bool] = None
    representative_provided: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
