# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .overdue_reminder_term import OverdueReminderTerm
from .recipients import Recipients


class OverdueReminderResponse(UniversalBaseModel):
    id: str
    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the OverdueReminder was created. Timestamps follow the ISO 8601 standard.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the OverdueReminder was last updated. Timestamps follow the ISO 8601 standard.
    """

    name: str
    recipients: typing.Optional[Recipients] = None
    terms: typing.Optional[typing.List[OverdueReminderTerm]] = pydantic.Field(default=None)
    """
    Overdue reminder terms to send for payment
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
