# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .api_version import ApiVersion
from .currency_settings_output import CurrencySettingsOutput
from .mail_settings import MailSettings
from .payable_settings import PayableSettings
from .payments_settings_output import PaymentsSettingsOutput
from .receivable_settings import ReceivableSettings
from .unit import Unit


class PartnerProjectSettingsPayloadOutput(UniversalBaseModel):
    currency: typing.Optional[CurrencySettingsOutput] = pydantic.Field(default=None)
    """
    Custom currency exchange rates.
    """

    payable: typing.Optional[PayableSettings] = pydantic.Field(default=None)
    """
    Settings for the payables module.
    """

    receivable: typing.Optional[ReceivableSettings] = pydantic.Field(default=None)
    """
    Settings for the receivables module.
    """

    mail: typing.Optional[MailSettings] = pydantic.Field(default=None)
    """
    Settings for email and mailboxes.
    """

    commercial_conditions: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Commercial conditions for receivables.
    """

    units: typing.Optional[typing.List[Unit]] = pydantic.Field(default=None)
    """
    Measurement units.
    """

    website: typing.Optional[str] = None
    default_role: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    A default role to provision upon new entity creation.
    """

    payments: typing.Optional[PaymentsSettingsOutput] = pydantic.Field(default=None)
    """
    Settings for the payments module.
    """

    api_version: typing.Optional[ApiVersion] = pydantic.Field(default=None)
    """
    Default API version for partner.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
