# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .payable_state_enum import PayableStateEnum


class PayableAggregatedItem(UniversalBaseModel):
    count: int = pydantic.Field()
    """
    The total count of payables with this specific status.
    """

    status: PayableStateEnum = pydantic.Field()
    """
    The status of the payable (e.g., paid, draft, etc.).
    """

    sum_total_amount: int = pydantic.Field()
    """
    The total sum of the amount field for all payables with this specific status.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
