# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class PayableCreditNoteData(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The unique identifier of the credit note.
    """

    document_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note's unique document number.
    """

    issued_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    The date when the credit note was issued, in the YYYY-MM-DD format
    """

    status: str = pydantic.Field()
    """
    The current status of the credit note in its lifecycle
    """

    total_amount: typing.Optional[int] = pydantic.Field(default=None)
    """
    Credit note total amount.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
