# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .file_schema3 import FileSchema3
from .payable_entity_address_schema import PayableEntityAddressSchema
from .payable_organization_schema import PayableOrganizationSchema
from .status_enum import StatusEnum


class PayableEntityOrganizationResponse(UniversalBaseModel):
    """
    A base for an entity response schema
    """

    id: str = pydantic.Field()
    """
    UUID entity ID
    """

    created_at: dt.datetime = pydantic.Field()
    """
    UTC datetime
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    UTC datetime
    """

    address: PayableEntityAddressSchema
    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    An official email address of the entity
    """

    logo: typing.Optional[FileSchema3] = pydantic.Field(default=None)
    """
    A logo image of the entity
    """

    organization: PayableOrganizationSchema = pydantic.Field()
    """
    A set of metadata describing an organization
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    A phone number of the entity
    """

    status: StatusEnum = pydantic.Field()
    """
    record status, 'active' by default
    """

    tax_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.
    """

    website: typing.Optional[str] = pydantic.Field(default=None)
    """
    A website of the entity
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
