# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .currency_enum import CurrencyEnum
from .payment_record_object_response import PaymentRecordObjectResponse


class PaymentRecordResponse(UniversalBaseModel):
    id: str
    amount: int = pydantic.Field()
    """
    Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).
    """

    currency: CurrencyEnum = pydantic.Field()
    """
    Currency code (ISO 4217) indicating the currency in which the payment was made.
    """

    entity_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user associated with the payment, if applicable.
    """

    is_external: bool
    object: PaymentRecordObjectResponse
    overpaid_amount: typing.Optional[int] = pydantic.Field(default=None)
    """
    Filled in a case, if payment amount is more, than total_amount
    """

    paid_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.
    """

    payment_intent_id: str = pydantic.Field()
    """
    Identifier for an payment intent.
    """

    payment_intent_status: typing.Optional[str] = pydantic.Field(default=None)
    """
    Raw status string of the external payment intent.
    """

    payment_method: typing.Optional[str] = pydantic.Field(default=None)
    """
    Payment method used or planned for the transaction.
    """

    planned_payment_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Scheduled date for future payments, required when the payment is planned but not yet executed.
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The current status of the payment record. Possible values: `created`, `processing`, `succeeded`, `canceled`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
