# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .recipients import Recipients
from .reminder import Reminder
from .status_enum import StatusEnum


class PaymentReminderResponse(UniversalBaseModel):
    id: str
    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the PaymentReminder was created. Timestamps follow the ISO 8601 standard.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the PaymentReminder was last updated. Timestamps follow the ISO 8601 standard.
    """

    entity_id: str
    name: str
    recipients: typing.Optional[Recipients] = None
    status: StatusEnum
    term1reminder: typing_extensions.Annotated[typing.Optional[Reminder], FieldMetadata(alias="term_1_reminder")] = (
        pydantic.Field(default=None)
    )
    """
    Reminder to send for first payment term
    """

    term2reminder: typing_extensions.Annotated[typing.Optional[Reminder], FieldMetadata(alias="term_2_reminder")] = (
        pydantic.Field(default=None)
    )
    """
    Reminder to send for second payment term
    """

    term_final_reminder: typing.Optional[Reminder] = pydantic.Field(default=None)
    """
    Reminder to send for final payment term
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
