# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .payment_term_discount_with_date import PaymentTermDiscountWithDate
from .term_final_with_date import TermFinalWithDate


class PaymentTerms(UniversalBaseModel):
    id: str
    name: typing.Optional[str] = None
    term1: typing_extensions.Annotated[typing.Optional[PaymentTermDiscountWithDate], FieldMetadata(alias="term_1")] = (
        pydantic.Field(default=None)
    )
    """
    The first tier of the payment term. Represents the terms of the first early discount.
    """

    term2: typing_extensions.Annotated[typing.Optional[PaymentTermDiscountWithDate], FieldMetadata(alias="term_2")] = (
        pydantic.Field(default=None)
    )
    """
    The second tier of the payment term. Defines the terms of the second early discount.
    """

    term_final: TermFinalWithDate = pydantic.Field()
    """
    The final tier of the payment term. Defines the invoice due date.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
