# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .allowed_countries import AllowedCountries
from .person_address_response import PersonAddressResponse
from .person_relationship_response import PersonRelationshipResponse


class PersonResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The person's unique identifier
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the person was created
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the person was updated
    """

    address: typing.Optional[PersonAddressResponse] = pydantic.Field(default=None)
    """
    The person's address
    """

    citizenship: typing.Optional[AllowedCountries] = pydantic.Field(default=None)
    """
    Required for persons of US entities. The country of the person's citizenship, as a two-letter country code (ISO 3166-1 alpha-2). In case of dual or multiple citizenship, specify any.
    """

    created_by_entity_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the entity user who created this person, or null if the person was created using a partner access token.
    """

    date_of_birth: typing.Optional[str] = pydantic.Field(default=None)
    """
    The person's date of birth
    """

    email: str = pydantic.Field()
    """
    The person's email address
    """

    entity_id: str = pydantic.Field()
    """
    Entity ID
    """

    first_name: str = pydantic.Field()
    """
    The person's first name
    """

    id_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The person's ID number, as appropriate for their country
    """

    last_name: str = pydantic.Field()
    """
    The person's last name
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The person's phone number
    """

    relationship: PersonRelationshipResponse = pydantic.Field()
    """
    Describes the person's relationship to the entity
    """

    ssn_last4: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="ssn_last_4")] = pydantic.Field(
        default=None
    )
    """
    The last four digits of the person's Social Security number
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
