# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .wc_repayment_type import WcRepaymentType


class PricingPlan(UniversalBaseModel):
    """
    A pricing plan of a financing offer
    """

    advance_rate_percentage: int = pydantic.Field()
    """
    Advance rate percentage. 10000 means 100%
    """

    fee_percentage: int = pydantic.Field()
    """
    Transaction fee percentage. 300 means 3.00%
    """

    repayment_type: WcRepaymentType = pydantic.Field()
    """
    Repayment type of the loan.
    """

    repayment_duration_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    This amount of days after which the repayment duration is due. This is only applicable for FIXED_DURATION repayment type
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
