# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .process_resource_script_snapshot import ProcessResourceScriptSnapshot
from .process_status_enum import ProcessStatusEnum


class ProcessResource(UniversalBaseModel):
    id: str
    created_at: dt.datetime
    updated_at: typing.Optional[dt.datetime] = None
    created_by: typing.Optional[str] = None
    error: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The error for the process.
    """

    input: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The input for the script.
    """

    metadata: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The metadata for the process.
    """

    script_snapshot: typing.Optional[ProcessResourceScriptSnapshot] = pydantic.Field(default=None)
    """
    The script snapshot taken when script started.
    """

    status: ProcessStatusEnum = pydantic.Field()
    """
    Tthe current status of the approval policy process.
    """

    updated_by: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
