# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .price import Price
from .product_service_type_enum import ProductServiceTypeEnum


class ProductServiceResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Unique ID of the product.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the product was created. Timestamps follow the ISO 8601 standard.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the product was last updated. Timestamps follow the ISO 8601 standard.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the product.
    """

    entity_id: str
    entity_user_id: typing.Optional[str] = None
    ledger_account_id: typing.Optional[str] = None
    measure_unit_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique ID reference of the unit used to measure the quantity of this product (e.g. items, meters, kilograms).
    """

    name: str = pydantic.Field()
    """
    Name of the product.
    """

    price: typing.Optional[Price] = None
    smallest_amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    The smallest amount allowed for this product.
    """

    type: typing.Optional[ProductServiceTypeEnum] = pydantic.Field(default=None)
    """
    Specifies whether this offering is a product or service. This may affect the applicable tax rates.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
