# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .tag_read_schema import TagReadSchema


class ProjectResource(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    A unique ID assigned to this project.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Project created at
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Last time project was updated at
    """

    code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project code
    """

    color: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project color
    """

    created_by_entity_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project created by entity user
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of project
    """

    end_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project end date
    """

    entity_id: str = pydantic.Field()
    """
    The ID of the entity to which the project was issued.
    """

    name: str = pydantic.Field()
    """
    The project name.
    """

    parent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Parent project ID
    """

    partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Project metadata
    """

    start_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project start date
    """

    tags: typing.Optional[typing.List[TagReadSchema]] = pydantic.Field(default=None)
    """
    A list of user-defined tags (labels) assigned to this project.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
