# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .currency_enum import CurrencyEnum
from .invoice import Invoice
from .payer_account_response import PayerAccountResponse
from .payment_intent import PaymentIntent
from .recipient_account_response import RecipientAccountResponse


class PublicPaymentLinkResponse(UniversalBaseModel):
    id: str
    amount: int
    currency: CurrencyEnum
    expires_at: dt.datetime
    invoice: typing.Optional[Invoice] = None
    payer: typing.Optional[PayerAccountResponse] = None
    payment_intent: typing.Optional[PaymentIntent] = None
    payment_intent_id: str
    payment_methods: typing.List[str]
    payment_page_url: str
    payment_reference: typing.Optional[str] = None
    recipient: RecipientAccountResponse
    return_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL where to redirect the payer after the payment. If `return_url` is specified, then after the payment is completed the payment page will display the "Return to platform" link that navigates to this URL.
    """

    status: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
