# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .counterpart_type import CounterpartType
from .language_code_enum import LanguageCodeEnum
from .purchase_order_counterpart_organization_response import PurchaseOrderCounterpartOrganizationResponse


class PurchaseOrderCounterpartOrganizationRootResponse(UniversalBaseModel):
    """
    Represents counterparts that are organizations (juridical persons).
    """

    id: str = pydantic.Field()
    """
    Unique ID of the counterpart.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Date and time when the counterpart was created. Timestamps follow the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Date and time when the counterpart was last updated. Timestamps follow the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
    """

    created_automatically: typing.Optional[bool] = pydantic.Field(default=None)
    """
    `true` if the counterpart was created automatically by Monite when processing incoming invoices with OCR. `false` if the counterpart was created by the API client.
    """

    default_billing_address_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the counterpart's billing address. If the counterpart is US-based and needs to accept ACH payments, this address must have all fields filled in. If `default_billing_address_id` is not defined, the default address is instead used as the billing address for ACH payments.
    """

    default_shipping_address_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the shipping address.
    """

    created_by_entity_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Entity user ID of counterpart creator.
    """

    language: typing.Optional[LanguageCodeEnum] = pydantic.Field(default=None)
    """
    The language used to generate PDF documents for this counterpart.
    """

    organization: PurchaseOrderCounterpartOrganizationResponse
    reminders_enabled: typing.Optional[bool] = None
    tax_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The counterpart's taxpayer identification number or tax ID. This field is required for counterparts that are non-VAT registered.
    """

    type: CounterpartType = pydantic.Field()
    """
    The counterpart type: `organization` (juridical person) or `individual` (natural person).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
