# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .currency_enum import CurrencyEnum


class PurchaseOrderItem(UniversalBaseModel):
    currency: CurrencyEnum = pydantic.Field()
    """
    The currency in which the price of the product is set.
    """

    name: str = pydantic.Field()
    """
    The name of the product to purchase
    """

    price: int = pydantic.Field()
    """
    The subtotal cost (excluding VAT), in [minor units](https://docs.monite.com/references/currencies#minor-units).
    """

    quantity: int = pydantic.Field()
    """
    Number (quantity) of products
    """

    unit: str = pydantic.Field()
    """
    Units (hours, meters, unit)
    """

    vat_rate: int = pydantic.Field()
    """
    Percent minor units. Example: 12.5% is 1250
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
