# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .currency_enum import CurrencyEnum
from .purchase_order_counterpart_address_schema import PurchaseOrderCounterpartAddressSchema
from .purchase_order_counterpart_schema import PurchaseOrderCounterpartSchema
from .purchase_order_item import PurchaseOrderItem
from .purchase_order_response_schema_entity import PurchaseOrderResponseSchemaEntity
from .purchase_order_vat_id import PurchaseOrderVatId


class PurchaseOrderResponseSchema(UniversalBaseModel):
    """
    Represents response for an Accounts Purchase Order document created by entity.
    """

    id: str = pydantic.Field()
    """
    A unique ID assigned to this purchase order.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the receivable was created. Timestamps follow the ISO 8601 standard.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the receivable was last updated. Timestamps follow the ISO 8601 standard.
    """

    counterpart: PurchaseOrderCounterpartSchema = pydantic.Field()
    """
    Counterpart information about an organization (juridical person) or individual (natural person) that provides goods and services to or buys them from an
    """

    counterpart_address: typing.Optional[PurchaseOrderCounterpartAddressSchema] = pydantic.Field(default=None)
    """
    Counterpart address data saved on creation or update of the purchase order.
    """

    counterpart_address_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of counterpart address object stored in counterparts service. If not provided, counterpart's default address is used.
    """

    counterpart_id: str = pydantic.Field()
    """
    Counterpart unique ID.
    """

    created_by_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the creator of the purchase order
    """

    currency: CurrencyEnum = pydantic.Field()
    """
    The currency in which the price of the product is set. (all items need to have the same currency)
    """

    document_id: str
    entity: PurchaseOrderResponseSchemaEntity = pydantic.Field()
    """
    Data of the entity (address, name, contact)
    """

    entity_id: str = pydantic.Field()
    """
    The ID of the entity which issued the purchase order.
    """

    entity_vat_id: typing.Optional[PurchaseOrderVatId] = None
    file_id: typing.Optional[str] = None
    file_url: typing.Optional[str] = None
    issued_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    When status changed from 'draft' to 'send', so after sending purchase order
    """

    items: typing.List[PurchaseOrderItem] = pydantic.Field()
    """
    List of item to purchase
    """

    message: str = pydantic.Field()
    """
    Msg which will be send to counterpart for who the purchase order is issued.
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project ID of a purchase order
    """

    status: str = pydantic.Field()
    """
    Purchase order can be in 'draft' state before sending it to counterpart. After that state is 'issued'
    """

    valid_for_days: int = pydantic.Field()
    """
    Number of days for which purchase order is valid
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
