# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ReceivableEntityBase(UniversalBaseModel):
    """
    A base schemas for an entity
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    An email of the entity
    """

    logo: typing.Optional[str] = pydantic.Field(default=None)
    """
    A link to the entity logo
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    A phone number of the entity
    """

    registration_authority: typing.Optional[str] = pydantic.Field(default=None)
    """
    The registration authority of the entity
    """

    registration_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The registration number of the entity
    """

    website: typing.Optional[str] = pydantic.Field(default=None)
    """
    A website of the entity
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
