# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .receivable_history_event_type_enum import ReceivableHistoryEventTypeEnum
from .receivable_history_response_event_data import ReceivableHistoryResponseEventData


class ReceivableHistoryResponse(UniversalBaseModel):
    """
    Represents an entry in the change history of an accounts receivable document.
    """

    id: str = pydantic.Field()
    """
    A unique ID of the history record.
    """

    current_pdf_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    A URL of the PDF file that shows the document state after the change. Available only for the following event types: `receivable_created`, `receivable_updated`, `status_changed`, and `payment_received`. In other event types the `current_pdf_url` value is `null`.
    
    In `payment_received` events, the `current_pdf_url` value is available only in case of full payments and only if the entity setting `generate_paid_invoice_pdf` is `true`.
    
    Note that Monite generates PDFs asynchronously. This means that the initial value of `current_pdf_url` for the abovementioned events right after they occurred is usually `null` and the value gets populated later after the PDF document has been generated.
    """

    entity_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the entity user who made the change or trigger the event, or `null` if it was done by using a partner access token.
    """

    event_data: ReceivableHistoryResponseEventData = pydantic.Field()
    """
    An object containing additional information about the event or change. The object structure varies based on the `event_type`. In `receivable_created` and `receivable_updated` events, `event_data` is an empty object `{}`.
    """

    event_type: ReceivableHistoryEventTypeEnum = pydantic.Field()
    """
    The type of the event or change. See [Event types](https://docs.monite.com/accounts-receivable/document-history#event-types).
    """

    receivable_id: str = pydantic.Field()
    """
    ID of the receivable document that was changed or triggered an event.
    """

    timestamp: dt.datetime = pydantic.Field()
    """
    UTC date and time when the event or change occurred.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
