# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .credit_note_response_payload_entity import CreditNoteResponsePayloadEntity
from .credit_note_state_enum import CreditNoteStateEnum
from .currency_enum import CurrencyEnum
from .discount import Discount
from .einvoicing_credentials import EinvoicingCredentials
from .invoice_response_payload_entity import InvoiceResponsePayloadEntity
from .language_code_enum import LanguageCodeEnum
from .payment_terms import PaymentTerms
from .quote_response_payload_entity import QuoteResponsePayloadEntity
from .quote_state_enum import QuoteStateEnum
from .receivable_counterpart_contact import ReceivableCounterpartContact
from .receivable_counterpart_type import ReceivableCounterpartType
from .receivable_counterpart_vat_id_response import ReceivableCounterpartVatIdResponse
from .receivable_entity_address_schema import ReceivableEntityAddressSchema
from .receivable_entity_vat_id_response import ReceivableEntityVatIdResponse
from .receivables_representation_of_counterpart_address import ReceivablesRepresentationOfCounterpartAddress
from .receivables_representation_of_entity_bank_account import ReceivablesRepresentationOfEntityBankAccount
from .receivables_status_enum import ReceivablesStatusEnum
from .related_documents import RelatedDocuments
from .response_item import ResponseItem
from .tag_read_schema import TagReadSchema
from .total_vat_amount_item import TotalVatAmountItem
from .vat_mode_enum import VatModeEnum


class ReceivableResponse_Quote(UniversalBaseModel):
    type: typing.Literal["quote"] = "quote"
    id: str
    created_at: dt.datetime
    updated_at: dt.datetime
    based_on: typing.Optional[str] = None
    based_on_document_id: typing.Optional[str] = None
    comment: typing.Optional[str] = None
    commercial_condition_description: typing.Optional[str] = None
    counterpart_billing_address: typing.Optional[ReceivablesRepresentationOfCounterpartAddress] = None
    counterpart_business_type: typing.Optional[str] = None
    counterpart_contact: typing.Optional[ReceivableCounterpartContact] = None
    counterpart_external_reference: typing.Optional[str] = None
    counterpart_id: str
    counterpart_name: typing.Optional[str] = None
    counterpart_shipping_address: typing.Optional[ReceivablesRepresentationOfCounterpartAddress] = None
    counterpart_tax_id: typing.Optional[str] = None
    counterpart_type: ReceivableCounterpartType
    counterpart_vat_id: typing.Optional[ReceivableCounterpartVatIdResponse] = None
    currency: CurrencyEnum
    deduction_amount: typing.Optional[int] = None
    deduction_memo: typing.Optional[str] = None
    discount: typing.Optional[Discount] = None
    discounted_subtotal: typing.Optional[int] = None
    document_id: typing.Optional[str] = None
    due_date: typing.Optional[str] = None
    einvoice_file_url: typing.Optional[str] = None
    entity: QuoteResponsePayloadEntity
    entity_address: ReceivableEntityAddressSchema
    entity_bank_account: typing.Optional[ReceivablesRepresentationOfEntityBankAccount] = None
    entity_user_id: typing.Optional[str] = None
    entity_vat_id: typing.Optional[ReceivableEntityVatIdResponse] = None
    expiry_date: typing.Optional[str] = None
    file_language: LanguageCodeEnum
    file_url: typing.Optional[str] = None
    footer: typing.Optional[str] = None
    issue_date: typing.Optional[dt.datetime] = None
    line_items: typing.List[ResponseItem]
    memo: typing.Optional[str] = None
    original_file_language: LanguageCodeEnum
    original_file_url: typing.Optional[str] = None
    partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    project_id: typing.Optional[str] = None
    quote_accept_page_url: typing.Optional[str] = None
    signature_required: typing.Optional[bool] = None
    status: QuoteStateEnum
    subtotal: typing.Optional[int] = None
    subtotal_after_vat: typing.Optional[int] = None
    tags: typing.Optional[typing.List[TagReadSchema]] = None
    total_amount: typing.Optional[int] = None
    total_vat_amount: int
    total_vat_amounts: typing.Optional[typing.List[TotalVatAmountItem]] = None
    total_withholding_tax: typing.Optional[int] = None
    trade_name: typing.Optional[str] = None
    vat_exempt: typing.Optional[bool] = None
    vat_exemption_rationale: typing.Optional[str] = None
    vat_inclusive_discount_mode: typing.Optional[VatModeEnum] = None
    vat_mode: typing.Optional[VatModeEnum] = None
    withholding_tax_rate: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ReceivableResponse_Invoice(UniversalBaseModel):
    type: typing.Literal["invoice"] = "invoice"
    id: str
    created_at: dt.datetime
    updated_at: dt.datetime
    amount_due: int
    amount_paid: int
    amount_to_pay: typing.Optional[int] = None
    based_on: typing.Optional[str] = None
    based_on_document_id: typing.Optional[str] = None
    comment: typing.Optional[str] = None
    commercial_condition_description: typing.Optional[str] = None
    counterpart_billing_address: typing.Optional[ReceivablesRepresentationOfCounterpartAddress] = None
    counterpart_business_type: typing.Optional[str] = None
    counterpart_contact: typing.Optional[ReceivableCounterpartContact] = None
    counterpart_einvoicing_credentials: typing.Optional[EinvoicingCredentials] = None
    counterpart_external_reference: typing.Optional[str] = None
    counterpart_id: str
    counterpart_name: typing.Optional[str] = None
    counterpart_shipping_address: typing.Optional[ReceivablesRepresentationOfCounterpartAddress] = None
    counterpart_tax_id: typing.Optional[str] = None
    counterpart_type: ReceivableCounterpartType
    counterpart_vat_id: typing.Optional[ReceivableCounterpartVatIdResponse] = None
    currency: CurrencyEnum
    deduction_amount: typing.Optional[int] = None
    deduction_memo: typing.Optional[str] = None
    discount: typing.Optional[Discount] = None
    discounted_subtotal: typing.Optional[int] = None
    document_id: typing.Optional[str] = None
    due_date: typing.Optional[str] = None
    einvoice_error_comment: typing.Optional[str] = None
    einvoice_file_url: typing.Optional[str] = None
    entity: InvoiceResponsePayloadEntity
    entity_address: ReceivableEntityAddressSchema
    entity_bank_account: typing.Optional[ReceivablesRepresentationOfEntityBankAccount] = None
    entity_user_id: typing.Optional[str] = None
    entity_vat_id: typing.Optional[ReceivableEntityVatIdResponse] = None
    file_language: LanguageCodeEnum
    file_url: typing.Optional[str] = None
    footer: typing.Optional[str] = None
    fulfillment_date: typing.Optional[str] = None
    is_einvoice: typing.Optional[bool] = None
    issue_date: typing.Optional[dt.datetime] = None
    line_items: typing.List[ResponseItem]
    memo: typing.Optional[str] = None
    network_credentials: typing.Optional[EinvoicingCredentials] = None
    original_file_language: LanguageCodeEnum
    original_file_url: typing.Optional[str] = None
    overdue_reminder_id: typing.Optional[str] = None
    paid_at: typing.Optional[dt.datetime] = None
    partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    payment_page_url: typing.Optional[str] = None
    payment_reminder_id: typing.Optional[str] = None
    payment_terms: typing.Optional[PaymentTerms] = None
    project_id: typing.Optional[str] = None
    purchase_order: typing.Optional[str] = None
    recurrence_id: typing.Optional[str] = None
    related_documents: RelatedDocuments
    status: ReceivablesStatusEnum
    subtotal: typing.Optional[int] = None
    subtotal_after_vat: typing.Optional[int] = None
    tags: typing.Optional[typing.List[TagReadSchema]] = None
    total_amount: typing.Optional[int] = None
    total_amount_with_credit_notes: int
    total_vat_amount: int
    total_vat_amounts: typing.Optional[typing.List[TotalVatAmountItem]] = None
    total_withholding_tax: typing.Optional[int] = None
    trade_name: typing.Optional[str] = None
    vat_exempt: typing.Optional[bool] = None
    vat_exemption_rationale: typing.Optional[str] = None
    vat_inclusive_discount_mode: typing.Optional[VatModeEnum] = None
    vat_mode: typing.Optional[VatModeEnum] = None
    withholding_tax_rate: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ReceivableResponse_CreditNote(UniversalBaseModel):
    type: typing.Literal["credit_note"] = "credit_note"
    id: str
    created_at: dt.datetime
    updated_at: dt.datetime
    based_on: typing.Optional[str] = None
    based_on_document_id: typing.Optional[str] = None
    commercial_condition_description: typing.Optional[str] = None
    counterpart_billing_address: typing.Optional[ReceivablesRepresentationOfCounterpartAddress] = None
    counterpart_business_type: typing.Optional[str] = None
    counterpart_contact: typing.Optional[ReceivableCounterpartContact] = None
    counterpart_einvoicing_credentials: typing.Optional[EinvoicingCredentials] = None
    counterpart_external_reference: typing.Optional[str] = None
    counterpart_id: str
    counterpart_name: typing.Optional[str] = None
    counterpart_shipping_address: typing.Optional[ReceivablesRepresentationOfCounterpartAddress] = None
    counterpart_tax_id: typing.Optional[str] = None
    counterpart_type: ReceivableCounterpartType
    counterpart_vat_id: typing.Optional[ReceivableCounterpartVatIdResponse] = None
    currency: CurrencyEnum
    deduction_amount: typing.Optional[int] = None
    deduction_memo: typing.Optional[str] = None
    discount: typing.Optional[Discount] = None
    discounted_subtotal: typing.Optional[int] = None
    document_id: typing.Optional[str] = None
    due_date: typing.Optional[str] = None
    einvoice_error_comment: typing.Optional[str] = None
    einvoice_file_url: typing.Optional[str] = None
    entity: CreditNoteResponsePayloadEntity
    entity_address: ReceivableEntityAddressSchema
    entity_bank_account: typing.Optional[ReceivablesRepresentationOfEntityBankAccount] = None
    entity_user_id: typing.Optional[str] = None
    entity_vat_id: typing.Optional[ReceivableEntityVatIdResponse] = None
    file_language: LanguageCodeEnum
    file_url: typing.Optional[str] = None
    footer: typing.Optional[str] = None
    issue_date: typing.Optional[dt.datetime] = None
    line_items: typing.List[ResponseItem]
    memo: typing.Optional[str] = None
    network_credentials: typing.Optional[EinvoicingCredentials] = None
    original_file_language: LanguageCodeEnum
    original_file_url: typing.Optional[str] = None
    partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    project_id: typing.Optional[str] = None
    purchase_order: typing.Optional[str] = None
    status: CreditNoteStateEnum
    subtotal: typing.Optional[int] = None
    subtotal_after_vat: typing.Optional[int] = None
    tags: typing.Optional[typing.List[TagReadSchema]] = None
    total_amount: typing.Optional[int] = None
    total_vat_amount: int
    total_vat_amounts: typing.Optional[typing.List[TotalVatAmountItem]] = None
    total_withholding_tax: typing.Optional[int] = None
    trade_name: typing.Optional[str] = None
    vat_exempt: typing.Optional[bool] = None
    vat_exemption_rationale: typing.Optional[str] = None
    vat_inclusive_discount_mode: typing.Optional[VatModeEnum] = None
    vat_mode: typing.Optional[VatModeEnum] = None
    withholding_tax_rate: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


ReceivableResponse = typing.Union[ReceivableResponse_Quote, ReceivableResponse_Invoice, ReceivableResponse_CreditNote]
