# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .allowed_countries import AllowedCountries


class ReceivablesCounterpartAddress(UniversalBaseModel):
    """
    Address information.
    """

    city: str = pydantic.Field()
    """
    City name.
    """

    country: AllowedCountries = pydantic.Field()
    """
    Two-letter ISO country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
    """

    line1: str = pydantic.Field()
    """
    Street address.
    """

    line2: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional address information (if any).
    """

    postal_code: str = pydantic.Field()
    """
    ZIP or postal code.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    State, region, province, or county.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
