# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ReceivablesRepresentationOfEntityBankAccount(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique ID of the entity bank account.
    """

    account_holder_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Account holder's name
    """

    account_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Account number (required if IBAN is not provided)
    """

    bank_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the entity's bank account.
    """

    bic: typing.Optional[str] = pydantic.Field(default=None)
    """
    The BIC of the entity's bank account.
    """

    iban: typing.Optional[str] = pydantic.Field(default=None)
    """
    The IBAN of the entity's bank account.
    """

    routing_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Routing number (US)
    """

    sort_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Sort code (GB)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
