# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .automation_level import AutomationLevel
from .day_of_month import DayOfMonth
from .recipients import Recipients
from .recurrence_iteration import RecurrenceIteration
from .recurrence_status import RecurrenceStatus


class Recurrence(UniversalBaseModel):
    id: str
    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the receivable was created. Timestamps follow the ISO 8601 standard.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the receivable was last updated. Timestamps follow the ISO 8601 standard.
    """

    automation_level: AutomationLevel = pydantic.Field()
    """
    Controls how invoices are processed when generated:
    - "draft": Creates invoices in draft status, requiring manual review, issuing, and sending
    - "issue": Automatically issues invoices but requires manual sending
    - "issue_and_send": Fully automates the process (creates, issues, and sends invoices)
    
    Default: "issue" (or "issue_and_send" if subject_text and body_text are provided)
    
    Note: When using "issue_and_send", both subject_text and body_text must be provided.
    """

    body_text: typing.Optional[str] = None
    current_iteration: int
    day_of_month: DayOfMonth
    end_month: int
    end_year: int
    invoice_id: str
    iterations: typing.List[RecurrenceIteration]
    recipients: typing.Optional[Recipients] = None
    start_month: int
    start_year: int
    status: RecurrenceStatus
    subject_text: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
