# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .receivable_mail_recipients import ReceivableMailRecipients
from .receivable_mail_status_enum import ReceivableMailStatusEnum
from .reminder_type_enum import ReminderTypeEnum


class ReminderMailSentEventData(UniversalBaseModel):
    """
    Contains information about an invoice reminder sent via email.
    """

    mail_id: str = pydantic.Field()
    """
    ID of the email sending operation. Can be used to get the email sending status from `GET /receivables/{receivable_id}/mails/{mail_id}`.
    """

    mail_status: ReceivableMailStatusEnum = pydantic.Field()
    """
    The overall email sending status across all recipients.
    """

    recipients: ReceivableMailRecipients = pydantic.Field()
    """
    Contains a list of email recipients (To, CC, BCC) and the email sending status for each recipient.
    """

    term: ReminderTypeEnum = pydantic.Field()
    """
    Invoice reminder type:
    
    * `term_1` - [payment reminder](https://docs.monite.com/accounts-receivable/invoices/payment-reminders) sent before discount date 1,
    * `term_2` - payment reminder sent before discount date 2,
    * `term_final` - payment reminder sent before the invoice due date.
    * `overdue` - [overdue reminder](https://docs.monite.com/accounts-receivable/invoices/overdue-reminders) sent after the due date.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
