# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .discount import Discount
from .line_item_product import LineItemProduct


class ResponseItem(UniversalBaseModel):
    discount: typing.Optional[Discount] = pydantic.Field(default=None)
    """
    The discount for a product.
    """

    product: LineItemProduct
    quantity: float = pydantic.Field()
    """
    The quantity of each of the goods, materials, or services listed in the receivable.
    """

    total_after_vat: int = pydantic.Field()
    """
    Total of line_item after VAT with applied line item discount in [minor units](https://docs.monite.com/references/currencies#minor-units).
    """

    total_before_vat: int = pydantic.Field()
    """
    Total of line_item before VAT in [minor units](https://docs.monite.com/references/currencies#minor-units).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
