# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .receivables_status_enum import ReceivablesStatusEnum


class StatusChangedEventData(UniversalBaseModel):
    """
    Contains information about a document's status change. See the applicable
    [invoice statuses](https://docs.monite.com/accounts-receivable/invoices/index),
    [quote statuses](https://docs.monite.com/accounts-receivable/quotes/index),
    and [credit note statuses](https://docs.monite.com/accounts-receivable/credit-notes#credit-note-lifecycle).
    """

    new_status: ReceivablesStatusEnum = pydantic.Field()
    """
    The new status of a document.
    """

    old_status: ReceivablesStatusEnum = pydantic.Field()
    """
    The old status of a document.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
