# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TemplateDataSchema(UniversalBaseModel):
    body_template: str = pydantic.Field()
    """
    Jinja2 compatible email body template
    """

    language: str = pydantic.Field()
    """
    Lowercase ISO code of language
    """

    subject_template: str = pydantic.Field()
    """
    Jinja2 compatible email subject template
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
