# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TotalVatAmountItem(UniversalBaseModel):
    id: typing.Optional[str] = None
    amount: int = pydantic.Field()
    """
    The total VAT of all line items, in [minor units](https://docs.monite.com/references/currencies#minor-units).
    """

    taxable_amount: int = pydantic.Field()
    """
    The amount on which this VAT is calculated, in [minor units](https://docs.monite.com/references/currencies#minor-units).
    """

    value: int = pydantic.Field()
    """
    Percent minor units. Example: 12.5% is 1250.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
