# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .receivable_counterpart_contact import ReceivableCounterpartContact
from .receivable_entity_base import ReceivableEntityBase
from .update_line_item_for_credit_note import UpdateLineItemForCreditNote


class UpdateCreditNote(UniversalBaseModel):
    counterpart_billing_address_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Address of invoicing, need to state as a separate fields for some countries if it differs from address of a company.
    """

    counterpart_contact: typing.Optional[ReceivableCounterpartContact] = pydantic.Field(default=None)
    """
    Additional information about counterpart contacts.
    """

    counterpart_shipping_address_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Address where goods were shipped / where services were provided.
    """

    entity: typing.Optional[ReceivableEntityBase] = None
    footer: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional text displayed below the line items table in the PDF.
    """

    line_items: typing.Optional[UpdateLineItemForCreditNote] = None
    memo: typing.Optional[str] = pydantic.Field(default=None)
    """
    A note with additional information for a receivable
    """

    partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Metadata for partner needs
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A project related to current receivable
    """

    tag_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of IDs of user-defined tags (labels) assigned to this receivable.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
