# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class UpdateEntityAddressSchema(UniversalBaseModel):
    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    A city (a full name) where the entity is registered
    """

    line1: typing.Optional[str] = pydantic.Field(default=None)
    """
    A street where the entity is registered
    """

    line2: typing.Optional[str] = pydantic.Field(default=None)
    """
    An alternative street used by the entity
    """

    postal_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    A postal code of the address where the entity is registered
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    A state in a country where the entity is registered
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
