# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .optional_individual_schema import OptionalIndividualSchema
from .optional_organization_schema import OptionalOrganizationSchema
from .update_entity_address_schema import UpdateEntityAddressSchema


class UpdateEntityRequest(UniversalBaseModel):
    """
    A schema for a request to update an entity
    """

    address: typing.Optional[UpdateEntityAddressSchema] = pydantic.Field(default=None)
    """
    An address description of the entity
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    An official email address of the entity
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact phone number of the entity. Required for US organizations to use payments.
    """

    website: typing.Optional[str] = pydantic.Field(default=None)
    """
    A website of the entity
    """

    tax_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.
    """

    registration_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.
    """

    registration_authority: typing.Optional[str] = pydantic.Field(default=None)
    """
    (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.
    """

    organization: typing.Optional[OptionalOrganizationSchema] = pydantic.Field(default=None)
    """
    A set of meta data describing the organization
    """

    individual: typing.Optional[OptionalIndividualSchema] = pydantic.Field(default=None)
    """
    A set of meta data describing the individual
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
