# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .allowed_countries import AllowedCountries
from .vat_rate_creator import VatRateCreator
from .vat_rate_status_enum import VatRateStatusEnum


class VatRateResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Unique identifier of the vat rate object.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Date/time when this rate was recorded in the table.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Date/time when this rate was updated in the table.
    """

    country: AllowedCountries = pydantic.Field()
    """
    Two-letter ISO country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
    """

    created_by: typing.Optional[VatRateCreator] = pydantic.Field(default=None)
    """
    By whom this rate was recorded: monite employee | accounting system.
    """

    status: typing.Optional[VatRateStatusEnum] = pydantic.Field(default=None)
    """
    Status for this vat rate: active | inactive.
    """

    valid_from: typing.Optional[str] = pydantic.Field(default=None)
    """
    Date starting from when this rate can be used.
    """

    valid_until: typing.Optional[str] = pydantic.Field(default=None)
    """
    Date when this rate was depreciated, after this date rate cannot be used.
    """

    value: int = pydantic.Field()
    """
    Percent minor units. Example: 12.5% is 1250.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
