# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.product_service_type_enum import ProductServiceTypeEnum
from ..types.vat_rate_list_response import VatRateListResponse
from .raw_client import AsyncRawVatRatesClient, RawVatRatesClient


class VatRatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVatRatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVatRatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVatRatesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        counterpart_address_id: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        counterpart_vat_id_id: typing.Optional[str] = None,
        entity_vat_id_id: typing.Optional[str] = None,
        product_type: typing.Optional[ProductServiceTypeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VatRateListResponse:
        """
        Parameters
        ----------
        counterpart_address_id : typing.Optional[str]

        counterpart_id : typing.Optional[str]

        counterpart_vat_id_id : typing.Optional[str]

        entity_vat_id_id : typing.Optional[str]

        product_type : typing.Optional[ProductServiceTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VatRateListResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.vat_rates.get()
        """
        _response = self._raw_client.get(
            counterpart_address_id=counterpart_address_id,
            counterpart_id=counterpart_id,
            counterpart_vat_id_id=counterpart_vat_id_id,
            entity_vat_id_id=entity_vat_id_id,
            product_type=product_type,
            request_options=request_options,
        )
        return _response.data


class AsyncVatRatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVatRatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVatRatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVatRatesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        counterpart_address_id: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        counterpart_vat_id_id: typing.Optional[str] = None,
        entity_vat_id_id: typing.Optional[str] = None,
        product_type: typing.Optional[ProductServiceTypeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VatRateListResponse:
        """
        Parameters
        ----------
        counterpart_address_id : typing.Optional[str]

        counterpart_id : typing.Optional[str]

        counterpart_vat_id_id : typing.Optional[str]

        entity_vat_id_id : typing.Optional[str]

        product_type : typing.Optional[ProductServiceTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VatRateListResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.vat_rates.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            counterpart_address_id=counterpart_address_id,
            counterpart_id=counterpart_id,
            counterpart_vat_id_id=counterpart_vat_id_id,
            entity_vat_id_id=entity_vat_id_id,
            product_type=product_type,
            request_options=request_options,
        )
        return _response.data
