# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.order_enum import OrderEnum
from ..types.webhook_object_type import WebhookObjectType
from ..types.webhook_subscription_cursor_fields import WebhookSubscriptionCursorFields
from ..types.webhook_subscription_pagination_resource import WebhookSubscriptionPaginationResource
from ..types.webhook_subscription_resource import WebhookSubscriptionResource
from ..types.webhook_subscription_resource_with_secret import WebhookSubscriptionResourceWithSecret
from .raw_client import AsyncRawWebhookSubscriptionsClient, RawWebhookSubscriptionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WebhookSubscriptionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWebhookSubscriptionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWebhookSubscriptionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWebhookSubscriptionsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[WebhookSubscriptionCursorFields] = None,
        object_type: typing.Optional[WebhookObjectType] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookSubscriptionPaginationResource:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[WebhookSubscriptionCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        object_type : typing.Optional[WebhookObjectType]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionPaginationResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.webhook_subscriptions.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            object_type=object_type,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        object_type: WebhookObjectType,
        url: str,
        event_types: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookSubscriptionResourceWithSecret:
        """
        Parameters
        ----------
        object_type : WebhookObjectType

        url : str

        event_types : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResourceWithSecret
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.webhook_subscriptions.create(object_type="account", url='url', )
        """
        _response = self._raw_client.create(
            object_type=object_type, url=url, event_types=event_types, request_options=request_options
        )
        return _response.data

    def get_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookSubscriptionResource:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.webhook_subscriptions.get_by_id(webhook_subscription_id='webhook_subscription_id', )
        """
        _response = self._raw_client.get_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.webhook_subscriptions.delete_by_id(webhook_subscription_id='webhook_subscription_id', )
        """
        _response = self._raw_client.delete_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        webhook_subscription_id: str,
        *,
        event_types: typing.Optional[typing.Sequence[str]] = OMIT,
        object_type: typing.Optional[WebhookObjectType] = OMIT,
        url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookSubscriptionResource:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        event_types : typing.Optional[typing.Sequence[str]]

        object_type : typing.Optional[WebhookObjectType]

        url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.webhook_subscriptions.update_by_id(webhook_subscription_id='webhook_subscription_id', )
        """
        _response = self._raw_client.update_by_id(
            webhook_subscription_id,
            event_types=event_types,
            object_type=object_type,
            url=url,
            request_options=request_options,
        )
        return _response.data

    def disable_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookSubscriptionResource:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.webhook_subscriptions.disable_by_id(webhook_subscription_id='webhook_subscription_id', )
        """
        _response = self._raw_client.disable_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data

    def enable_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookSubscriptionResource:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.webhook_subscriptions.enable_by_id(webhook_subscription_id='webhook_subscription_id', )
        """
        _response = self._raw_client.enable_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data

    def regenerate_secret_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookSubscriptionResourceWithSecret:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResourceWithSecret
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.webhook_subscriptions.regenerate_secret_by_id(webhook_subscription_id='webhook_subscription_id', )
        """
        _response = self._raw_client.regenerate_secret_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data


class AsyncWebhookSubscriptionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWebhookSubscriptionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWebhookSubscriptionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWebhookSubscriptionsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[WebhookSubscriptionCursorFields] = None,
        object_type: typing.Optional[WebhookObjectType] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookSubscriptionPaginationResource:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[WebhookSubscriptionCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        object_type : typing.Optional[WebhookObjectType]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionPaginationResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.webhook_subscriptions.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            object_type=object_type,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        object_type: WebhookObjectType,
        url: str,
        event_types: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookSubscriptionResourceWithSecret:
        """
        Parameters
        ----------
        object_type : WebhookObjectType

        url : str

        event_types : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResourceWithSecret
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.webhook_subscriptions.create(object_type="account", url='url', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            object_type=object_type, url=url, event_types=event_types, request_options=request_options
        )
        return _response.data

    async def get_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookSubscriptionResource:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.webhook_subscriptions.get_by_id(webhook_subscription_id='webhook_subscription_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.webhook_subscriptions.delete_by_id(webhook_subscription_id='webhook_subscription_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        webhook_subscription_id: str,
        *,
        event_types: typing.Optional[typing.Sequence[str]] = OMIT,
        object_type: typing.Optional[WebhookObjectType] = OMIT,
        url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookSubscriptionResource:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        event_types : typing.Optional[typing.Sequence[str]]

        object_type : typing.Optional[WebhookObjectType]

        url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.webhook_subscriptions.update_by_id(webhook_subscription_id='webhook_subscription_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            webhook_subscription_id,
            event_types=event_types,
            object_type=object_type,
            url=url,
            request_options=request_options,
        )
        return _response.data

    async def disable_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookSubscriptionResource:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.webhook_subscriptions.disable_by_id(webhook_subscription_id='webhook_subscription_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.disable_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data

    async def enable_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookSubscriptionResource:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.webhook_subscriptions.enable_by_id(webhook_subscription_id='webhook_subscription_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.enable_by_id(webhook_subscription_id, request_options=request_options)
        return _response.data

    async def regenerate_secret_by_id(
        self, webhook_subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookSubscriptionResourceWithSecret:
        """
        Parameters
        ----------
        webhook_subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookSubscriptionResourceWithSecret
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.webhook_subscriptions.regenerate_secret_by_id(webhook_subscription_id='webhook_subscription_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.regenerate_secret_by_id(
            webhook_subscription_id, request_options=request_options
        )
        return _response.data
