"""Stub file for reflex/components/core/clipboard.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any

from reflex.components.base.fragment import Fragment
from reflex.components.core.breakpoints import Breakpoints
from reflex.event import EventType, PointerEventInfo
from reflex.utils.imports import ImportVar
from reflex.vars.base import Var

class Clipboard(Fragment):
    @classmethod
    def create(
        cls,
        *children,
        targets: Sequence[str] | Var[Sequence[str]] | None = None,
        on_paste_event_actions: Var[dict[str, bool | int]]
        | dict[str, bool | int]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_paste: EventType[()] | EventType[list[tuple[str, str]]] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Clipboard:
        """Create a Clipboard component.

        Args:
            *children: The children of the component.
            targets: The element ids to attach the event listener to. Defaults to all child components or the document.
            on_paste: Called when the user pastes data into the document. Data is a list of tuples of (mime_type, data). Binary types will be base64 encoded as a data uri.
            on_paste_event_actions: Save the original event actions for the on_paste event.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Clipboard Component.
        """

    def add_imports(self) -> dict[str, ImportVar]: ...
    def add_hooks(self) -> list[str | Var[str]]: ...

clipboard = Clipboard.create
