"""Stub file for reflex/components/radix/themes/layout/list.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Iterable, Mapping, Sequence
from typing import Any, Literal

from reflex.components.component import ComponentNamespace
from reflex.components.core.breakpoints import Breakpoints
from reflex.components.el.elements.base import BaseHTML
from reflex.components.el.elements.typography import Li, Ol, Ul
from reflex.components.markdown.markdown import MarkdownComponentMap
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

LiteralListStyleTypeUnordered = Literal["none", "disc", "circle", "square"]
LiteralListStyleTypeOrdered = Literal[
    "none",
    "decimal",
    "decimal-leading-zero",
    "lower-roman",
    "upper-roman",
    "lower-greek",
    "lower-latin",
    "upper-latin",
    "armenian",
    "georgian",
    "lower-alpha",
    "upper-alpha",
    "hiragana",
    "katakana",
]

class BaseList(BaseHTML, MarkdownComponentMap):
    @classmethod
    def create(
        cls,
        *children,
        list_style_type: Literal[
            "armenian",
            "decimal",
            "decimal-leading-zero",
            "georgian",
            "hiragana",
            "katakana",
            "lower-alpha",
            "lower-greek",
            "lower-latin",
            "lower-roman",
            "none",
            "upper-alpha",
            "upper-latin",
            "upper-roman",
        ]
        | Literal["circle", "disc", "none", "square"]
        | Var[
            Literal[
                "armenian",
                "decimal",
                "decimal-leading-zero",
                "georgian",
                "hiragana",
                "katakana",
                "lower-alpha",
                "lower-greek",
                "lower-latin",
                "lower-roman",
                "none",
                "upper-alpha",
                "upper-latin",
                "upper-roman",
            ]
            | Literal["circle", "disc", "none", "square"]
        ]
        | None = None,
        items: Iterable | Var[Iterable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> BaseList:
        """Create a list component.

        Args:
            *children: The children of the component.
            list_style_type: The style of the list. Default to "none".
            items: A list of items to add to the list.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The list component.
        """

    def add_style(self) -> dict[str, Any] | None: ...

class UnorderedList(BaseList, Ul):
    @classmethod
    def create(
        cls,
        *children,
        list_style_type: Literal[
            "armenian",
            "decimal",
            "decimal-leading-zero",
            "georgian",
            "hiragana",
            "katakana",
            "lower-alpha",
            "lower-greek",
            "lower-latin",
            "lower-roman",
            "none",
            "upper-alpha",
            "upper-latin",
            "upper-roman",
        ]
        | Literal["circle", "disc", "none", "square"]
        | Var[
            Literal[
                "armenian",
                "decimal",
                "decimal-leading-zero",
                "georgian",
                "hiragana",
                "katakana",
                "lower-alpha",
                "lower-greek",
                "lower-latin",
                "lower-roman",
                "none",
                "upper-alpha",
                "upper-latin",
                "upper-roman",
            ]
            | Literal["circle", "disc", "none", "square"]
        ]
        | None = None,
        items: Iterable | Var[Iterable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> UnorderedList:
        """Create an unordered list component.

        Args:
            *children: The children of the component.
            list_style_type: The style of the list. Default to "none".
            items: A list of items to add to the list.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The list component.
        """

class OrderedList(BaseList, Ol):
    @classmethod
    def create(
        cls,
        *children,
        list_style_type: Literal[
            "armenian",
            "decimal",
            "decimal-leading-zero",
            "georgian",
            "hiragana",
            "katakana",
            "lower-alpha",
            "lower-greek",
            "lower-latin",
            "lower-roman",
            "none",
            "upper-alpha",
            "upper-latin",
            "upper-roman",
        ]
        | Literal["circle", "disc", "none", "square"]
        | Var[
            Literal[
                "armenian",
                "decimal",
                "decimal-leading-zero",
                "georgian",
                "hiragana",
                "katakana",
                "lower-alpha",
                "lower-greek",
                "lower-latin",
                "lower-roman",
                "none",
                "upper-alpha",
                "upper-latin",
                "upper-roman",
            ]
            | Literal["circle", "disc", "none", "square"]
        ]
        | None = None,
        items: Iterable | Var[Iterable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> OrderedList:
        """Create an ordered list component.

        Args:
            *children: The children of the component.
            list_style_type: The style of the list. Default to "none".
            items: A list of items to add to the list.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The list component.
        """

class ListItem(Li, MarkdownComponentMap):
    @classmethod
    def create(
        cls,
        *children,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ListItem:
        """Create a list item component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The list item component.
        """

class List(ComponentNamespace):
    item = staticmethod(ListItem.create)
    ordered = staticmethod(OrderedList.create)
    unordered = staticmethod(UnorderedList.create)

    @staticmethod
    def __call__(
        *children,
        list_style_type: Literal[
            "armenian",
            "decimal",
            "decimal-leading-zero",
            "georgian",
            "hiragana",
            "katakana",
            "lower-alpha",
            "lower-greek",
            "lower-latin",
            "lower-roman",
            "none",
            "upper-alpha",
            "upper-latin",
            "upper-roman",
        ]
        | Literal["circle", "disc", "none", "square"]
        | Var[
            Literal[
                "armenian",
                "decimal",
                "decimal-leading-zero",
                "georgian",
                "hiragana",
                "katakana",
                "lower-alpha",
                "lower-greek",
                "lower-latin",
                "lower-roman",
                "none",
                "upper-alpha",
                "upper-latin",
                "upper-roman",
            ]
            | Literal["circle", "disc", "none", "square"]
        ]
        | None = None,
        items: Iterable | Var[Iterable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> BaseList:
        """Create a list component.

        Args:
            *children: The children of the component.
            list_style_type: The style of the list. Default to "none".
            items: A list of items to add to the list.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The list component.
        """

list_ns = List()
list_item = list_ns.item
ordered_list = list_ns.ordered
unordered_list = list_ns.unordered
