"""Stub file for reflex/components/react_router/dom.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal, TypedDict

from reflex.components.core.breakpoints import Breakpoints
from reflex.components.el.elements.inline import A
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

LiteralLinkDiscover = Literal["none", "render"]

class To(TypedDict):
    pathname: str
    search: str
    hash: str

class ReactRouterLink(A):
    @classmethod
    def create(
        cls,
        *children,
        to: To | Var[To | str] | str | None = None,
        replace: Var[bool] | bool | None = None,
        reload_document: Var[bool] | bool | None = None,
        prevent_scroll_reset: Var[bool] | bool | None = None,
        discover: Literal["none", "render"]
        | Var[Literal["none", "render"]]
        | None = None,
        view_transition: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ReactRouterLink:
        """Create a ReactRouterLink component for client-side navigation.

        Args:
            *children: The children of the component.
            to: The page to link to.
            replace: Replaces the current entry in the history stack instead of pushing a new one onto it.
            reload_document: Will use document navigation instead of client side routing when the link is clicked: the browser will handle the transition normally (as if it were an <a href>).
            prevent_scroll_reset: Prevents the scroll position from being reset to the top of the window when the link is clicked and the app is using ScrollRestoration. This only prevents new locations resetting scroll to the top, scroll position will be restored for back/forward button navigation.
            discover: Defines the link discovery behavior
            view_transition: Enables a View Transition for this navigation.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The ReactRouterLink component.
        """
