"""Recharts components."""

from __future__ import annotations

from reflex.utils import lazy_loader

_SUBMOD_ATTRS: dict = {
    "cartesian": [
        "area",
        "Area",
        "bar",
        "Bar",
        "line",
        "Line",
        "scatter",
        "Scatter",
        "x_axis",
        "XAxis",
        "y_axis",
        "YAxis",
        "z_axis",
        "ZAxis",
        "brush",
        "Brush",
        "cartesian_axis",
        "CartesianAxis",
        "cartesian_grid",
        "CartesianGrid",
        "reference_line",
        "ReferenceLine",
        "reference_dot",
        "ReferenceDot",
        "reference_area",
        "ReferenceArea",
        "error_bar",
        "ErrorBar",
        "funnel",
        "Funnel",
    ],
    "charts": [
        "area_chart",
        "AreaChart",
        "bar_chart",
        "BarChart",
        "line_chart",
        "LineChart",
        "composed_chart",
        "ComposedChart",
        "pie_chart",
        "PieChart",
        "radar_chart",
        "RadarChart",
        "radial_bar_chart",
        "RadialBarChart",
        "scatter_chart",
        "ScatterChart",
        "funnel_chart",
        "FunnelChart",
        "treemap",
        "Treemap",
    ],
    "general": [
        "responsive_container",
        "ResponsiveContainer",
        "legend",
        "Legend",
        "tooltip",
        "graphing_tooltip",
        "GraphingTooltip",
        "label",
        "Label",
        "label_list",
        "LabelList",
        "cell",
        "Cell",
    ],
    "polar": [
        "pie",
        "Pie",
        "radar",
        "Radar",
        "radial_bar",
        "RadialBar",
        "polar_angle_axis",
        "PolarAngleAxis",
        "polar_grid",
        "PolarGrid",
        "polar_radius_axis",
        "PolarRadiusAxis",
    ],
    "recharts": [
        "LiteralAnimationEasing",
        "LiteralAxisType",
        "LiteralBarChartStackOffset",
        "LiteralComposedChartBaseValue",
        "LiteralCurveType",
        "LiteralDirection",
        "LiteralGridType",
        "LiteralIconType",
        "LiteralIfOverflow",
        "LiteralInterval",
        "LiteralLayout",
        "LiteralLegendAlign",
        "LiteralLegendType",
        "LiteralLineType",
        "LiteralOrientation",
        "LiteralOrientationLeftRightMiddle",
        "LiteralOrientationTopBottom",
        "LiteralOrientationTopBottomLeftRight",
        "LiteralPolarRadiusType",
        "LiteralScale",
        "LiteralShape",
        "LiteralStackOffset",
        "LiteralSyncMethod",
        "LiteralVerticalAlign",
    ],
}

__getattr__, __dir__, __all__ = lazy_loader.attach(
    __name__,
    submod_attrs=_SUBMOD_ATTRS,
)
