"""Stub file for reflex/components/sonner/toast.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
import dataclasses
from collections.abc import Mapping, Sequence
from typing import Any, Literal

from reflex.components.component import Component, ComponentNamespace
from reflex.components.core.breakpoints import Breakpoints
from reflex.components.lucide.icon import Icon
from reflex.components.props import NoExtrasAllowedProps
from reflex.constants.base import Dirs
from reflex.event import EventSpec, EventType, PointerEventInfo
from reflex.style import Style
from reflex.utils.imports import ImportVar
from reflex.utils.serializers import serializer
from reflex.vars import VarData
from reflex.vars.base import Var

LiteralPosition = Literal[
    "top-left",
    "top-center",
    "top-right",
    "bottom-left",
    "bottom-center",
    "bottom-right",
]
toast_ref = Var(
    _js_expr="refs['__toast']",
    _var_data=VarData(imports={f"$/{Dirs.STATE_PATH}": [ImportVar(tag="refs")]}),
)

@dataclasses.dataclass
class ToastAction:
    label: str
    on_click: Any

@serializer
def serialize_action(action: ToastAction) -> dict: ...

class ToastProps(NoExtrasAllowedProps):
    title: str | Var | None
    description: str | Var | None
    close_button: bool | None
    invert: bool | None
    important: bool | None
    duration: int | None
    position: LiteralPosition | None
    dismissible: bool | None
    action: ToastAction | None
    cancel: ToastAction | None
    id: str | Var | None
    unstyled: bool | None
    style: Style | None
    class_name: str | None
    action_button_styles: Style | None
    cancel_button_styles: Style | None
    on_dismiss: Any | None
    on_auto_close: Any | None

    def dict(self, *args: Any, **kwargs: Any) -> dict[str, Any]: ...

class Toaster(Component):
    def add_hooks(self) -> list[Var | str]: ...
    @staticmethod
    def send_toast(
        message: str | Var[str] = "",
        level: str | None = None,
        fallback_to_alert: bool = False,
        **props,
    ) -> EventSpec: ...
    @staticmethod
    def toast_info(message: str | Var[str] = "", **kwargs: Any) -> EventSpec: ...
    @staticmethod
    def toast_warning(message: str | Var[str] = "", **kwargs: Any) -> EventSpec: ...
    @staticmethod
    def toast_error(message: str | Var[str] = "", **kwargs: Any) -> EventSpec: ...
    @staticmethod
    def toast_success(message: str | Var[str] = "", **kwargs: Any) -> EventSpec: ...
    @staticmethod
    def toast_loading(message: str | Var[str] = "", **kwargs: Any) -> EventSpec: ...
    @staticmethod
    def toast_dismiss(id: Var[str] | str | None = None) -> EventSpec: ...
    @classmethod
    def create(
        cls,
        *children,
        theme: Var[str] | str | None = None,
        rich_colors: Var[bool] | bool | None = None,
        expand: Var[bool] | bool | None = None,
        visible_toasts: Var[int] | int | None = None,
        position: Literal[
            "bottom-center",
            "bottom-left",
            "bottom-right",
            "top-center",
            "top-left",
            "top-right",
        ]
        | Var[
            Literal[
                "bottom-center",
                "bottom-left",
                "bottom-right",
                "top-center",
                "top-left",
                "top-right",
            ]
        ]
        | None = None,
        close_button: Var[bool] | bool | None = None,
        offset: Var[str] | str | None = None,
        dir: Var[str] | str | None = None,
        hotkey: Var[str] | str | None = None,
        invert: Var[bool] | bool | None = None,
        toast_options: ToastProps | Var[ToastProps] | None = None,
        gap: Var[int] | int | None = None,
        loading_icon: Icon | Var[Icon] | None = None,
        pause_when_page_is_hidden: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Toaster:
        """Create a toaster component.

        Args:
            *children: The children of the toaster.
            theme: the theme of the toast
            rich_colors: whether to show rich colors
            expand: whether to expand the toast
            visible_toasts: the number of toasts that are currently visible
            position: the position of the toast
            close_button: whether to show the close button
            offset: offset of the toast
            dir: directionality of the toast (default: ltr)
            hotkey: Keyboard shortcut that will move focus to the toaster area.
            invert: Dark toasts in light mode and vice versa.
            toast_options: These will act as default options for all toasts. See toast() for all available options.
            gap: Gap between toasts when expanded
            loading_icon: Changes the default loading icon
            pause_when_page_is_hidden: Pauses toast timers when the page is hidden, e.g., when the tab is backgrounded, the browser is minimized, or the OS is locked.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the toaster.

        Returns:
            The toaster component.
        """

class ToastNamespace(ComponentNamespace):
    provider = staticmethod(Toaster.create)
    options = staticmethod(ToastProps)
    info = staticmethod(Toaster.toast_info)
    warning = staticmethod(Toaster.toast_warning)
    error = staticmethod(Toaster.toast_error)
    success = staticmethod(Toaster.toast_success)
    loading = staticmethod(Toaster.toast_loading)
    dismiss = staticmethod(Toaster.toast_dismiss)

    @staticmethod
    def __call__(
        message: str | Var[str] | str = "",
        level: str | None = None,
        fallback_to_alert: bool = False,
        **props,
    ) -> EventSpec:
        """Send a toast message.

        Args:
            message: The message to display.
            level: The level of the toast.
            fallback_to_alert: Whether to fallback to an alert if the toaster is not created.
            **props: The options for the toast.

        Raises:
            ValueError: If the Toaster component is not created.

        Returns:
            The toast event.
        """

toast = ToastNamespace()
