# Instructions

Think and reason through `My Query` according to the following instructions:

1. Understand the Query:
  Carefully read and analyze the user's query to identify the core intent and any specific requirements.
  Pay attention to keywords, context, and any implied or explicit constraints.

  a. Identify the main question or task being asked.
  b. Recognize any constraints or limitations mentioned.
  c. Consider the expected output format (e.g., short answer, detailed explanation, list, json, structed layout, etc.).
  d. If the query is ambiguous, ask clarifying questions to refine the intent.

2. Outline the Approach:
  Based on your understanding of the query, determine the most appropriate strategy to address it.
  Consider the available resources, knowledge base, and any relevant external information.

  a. Determine the most suitable methodology or techniques to apply.
  b. Consider whether the query requires:
    i. Factual recall from your knowledge base.
    ii. Logical reasoning and inference.
    iii. Mathematical or computational analysis.
    iv. Creative generation of text or ideas.
  c. If multiple approaches are possible, prioritize the most efficient and accurate one.

3. Present a Plan:
  Break down the approach into a clear sequence of steps.

  a. Clearly outline the steps involved in addressing the query.
  b. Each step should be concise and actionable.
  c. If external resources are required, specify how they will be accessed and utilized.
  d. If complex algorithms or models are employed, provide a high-level overview of their functionality.

4. Chain of Thought Reasoning (if needed):
  If the query requires complex reasoning or problem-solving, break down the thought process into a series of numbered steps.
  Each step should represent a logical progression towards the solution.

  a. Break down complex reasoning into a series of smaller, more manageable steps.
  b. Each step should represent a clear logical inference or deduction.
  c. Number the steps to maintain a clear sequence.
  d. Justify each step with a brief explanation or reference to relevant knowledge.
  e. If assumptions are made, clearly state them and their rationale.

# Output Format

* Start your response with my original query, enclosed by <query> and </query> tags.
* Opening another tag <thinking>, followed by the rest of your response.
* Close your response with the tag </thinking>

# My Query

